<?php
/**
 * ACF Fields for Ex Page Template
 */
function register_ex_page_fields_b2() {
    if (!function_exists('acf_add_local_field_group')) {
        return;
    }

    acf_add_local_field_group(array(
        'key' => 'group_ex_page_b2',
        'title' => 'Ex Page Settings (Theme 2)',
        'fields' => array(
            // Main Banner Tab
            array(
                'key' => 'field_ex_banner_tab_b2',
                'label' => 'Main Banner',
                'type' => 'tab',
            ),
            array(
                'key' => 'field_ex_banner_bg_b2',
                'label' => 'Background Image',
                'name' => 'ex_banner_bg_b2',
                'type' => 'image',
                'return_format' => 'url',
            ),
            array(
                'key' => 'field_ex_banner_players_b2',
                'label' => 'Players Image',
                'name' => 'ex_banner_players_b2',
                'type' => 'image',
                'return_format' => 'array',
            ),
            array(
                'key' => 'field_ex_rating_b2',
                'label' => 'Rating Text',
                'name' => 'ex_rating_b2',
                'type' => 'text',
            ),
            array(
                'key' => 'field_ex_heading_b2',
                'label' => 'Heading',
                'name' => 'ex_heading_b2',
                'type' => 'text',
            ),
            array(
                'key' => 'field_ex_subheading_b2',
                'label' => 'Subheading',
                'name' => 'ex_subheading_b2',
                'type' => 'textarea',
            ),

            // Content Tab
            array(
                'key' => 'field_ex_content_tab_b2',
                'label' => 'Content',
                'type' => 'tab',
            ),
            array(
                'key' => 'field_ex_content_b2',
                'label' => 'Page Content',
                'name' => 'ex_content_b2',
                'type' => 'flexible_content',
                'layouts' => array(
                    'layout_ex_intro' => array(
                        'key' => 'layout_ex_intro_b2',
                        'name' => 'intro_block',
                        'label' => 'Intro Block',
                        'display' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_ex_intro_content_b2',
                                'label' => 'Content',
                                'name' => 'content',
                                'type' => 'wysiwyg',
                            ),
                        ),
                    ),
                    'layout_ex_text_image' => array(
                        'key' => 'layout_ex_text_image_b2',
                        'name' => 'text_image_block',
                        'label' => 'Text & Image Block',
                        'display' => 'block',
                        'sub_fields' => array(
                            array('key' => 'field_ex_ti_heading_b2', 'label' => 'Heading', 'name' => 'heading', 'type' => 'text'),
                            array('key' => 'field_ex_ti_image_b2', 'label' => 'Image', 'name' => 'image', 'type' => 'image', 'return_format' => 'array'),
                            array('key' => 'field_ex_ti_content_b2', 'label' => 'Content', 'name' => 'content', 'type' => 'wysiwyg'),
                            array('key' => 'field_ex_ti_show_button_b2', 'label' => 'Show Button', 'name' => 'show_button', 'type' => 'true_false', 'ui' => 1),
                        ),
                    ),
                    'layout_ex_faq' => array(
                        'key' => 'layout_ex_faq_b2',
                        'name' => 'faq_block',
                        'label' => 'FAQ Block',
                        'display' => 'block',
                        'sub_fields' => array(
                            array('key' => 'field_ex_faq_heading_b2', 'label' => 'Heading', 'name' => 'heading', 'type' => 'text'),
                            array(
                                'key' => 'field_ex_faq_items_b2',
                                'label' => 'FAQ Items',
                                'name' => 'items',
                                'type' => 'repeater',
                                'sub_fields' => array(
                                    array('key' => 'field_ex_faq_question_b2', 'label' => 'Question', 'name' => 'question', 'type' => 'text'),
                                    array('key' => 'field_ex_faq_answer_b2', 'label' => 'Answer', 'name' => 'answer', 'type' => 'wysiwyg'),
                                ),
                            ),
                        ),
                    ),
                ),
            ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'page_template',
                    'operator' => '==',
                    'value' => 'ex-page-template.php',
                ),
            ),
        ),
        'position' => 'normal',
        'style' => 'default',
        'label_placement' => 'top',
    ));
}
add_action('acf/init', 'register_ex_page_fields_b2');
