<?php
/**
 * ACF Fields for Main Page Template
 */
function register_main_page_fields_b2() {
    if (!function_exists('acf_add_local_field_group')) {
        return;
    }

    acf_add_local_field_group(array(
        'key' => 'group_main_page_b2',
        'title' => 'Main Page Settings (Theme 2)',
        'fields' => array(
            // Main Banner Tab
            array(
                'key' => 'field_main_banner_tab_b2',
                'label' => 'Main Banner',
                'type' => 'tab',
            ),
            array(
                'key' => 'field_main_banner_bg_b2',
                'label' => 'Background Image',
                'name' => 'main_banner_bg_b2',
                'type' => 'image',
                'return_format' => 'url',
            ),
            array(
                'key' => 'field_main_banner_players_b2',
                'label' => 'Players Image',
                'name' => 'main_banner_players_b2',
                'type' => 'image',
                'return_format' => 'array',
            ),
            array(
                'key' => 'field_main_rating_b2',
                'label' => 'Rating Text',
                'name' => 'main_rating_b2',
                'type' => 'text',
            ),
            array(
                'key' => 'field_main_heading_b2',
                'label' => 'Heading',
                'name' => 'main_heading_b2',
                'type' => 'text',
            ),
            array(
                'key' => 'field_main_subheading_b2',
                'label' => 'Subheading',
                'name' => 'main_subheading_b2',
                'type' => 'textarea',
            ),

            // Content Tab
            array(
                'key' => 'field_main_content_tab_b2',
                'label' => 'Content',
                'type' => 'tab',
            ),
            array(
                'key' => 'field_main_content_b2',
                'label' => 'Page Content',
                'name' => 'main_content_b2',
                'type' => 'flexible_content',
                'layouts' => array(
                    // Layout for Intro Text
                    'layout_intro_text' => array(
                        'key' => 'layout_intro_text_b2',
                        'name' => 'intro_text_block',
                        'label' => 'Intro Text Block',
                        'display' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_intro_text_content_b2',
                                'label' => 'Content',
                                'name' => 'content',
                                'type' => 'wysiwyg',
                            ),
                        ),
                    ),
                    // Layout for Games
                    'layout_games' => array(
                        'key' => 'layout_games_b2',
                        'name' => 'games_block',
                        'label' => 'Games Block',
                        'display' => 'block',
                        'sub_fields' => array(
                            array('key' => 'field_games_heading_b2', 'label' => 'Heading', 'name' => 'heading', 'type' => 'text'),
                            array(
                                'key' => 'field_games_items_b2',
                                'label' => 'Games',
                                'name' => 'games',
                                'type' => 'repeater',
                                'sub_fields' => array(
                                    array('key' => 'field_game_image_b2', 'label' => 'Image', 'name' => 'image', 'type' => 'image', 'return_format' => 'array'),
                                    array('key' => 'field_game_name_b2', 'label' => 'Name', 'name' => 'name', 'type' => 'text'),
                                ),
                            ),
                        ),
                    ),
                    // Layout for Text with Image
                    'layout_text_image' => array(
                        'key' => 'layout_text_image_b2',
                        'name' => 'text_image_block',
                        'label' => 'Text & Image Block',
                        'display' => 'block',
                        'sub_fields' => array(
                            array('key' => 'field_ti_heading_b2', 'label' => 'Heading', 'name' => 'heading', 'type' => 'text'),
                            array('key' => 'field_ti_image_b2', 'label' => 'Image', 'name' => 'image', 'type' => 'image', 'return_format' => 'array'),
                            array('key' => 'field_ti_content_b2', 'label' => 'Content', 'name' => 'content', 'type' => 'wysiwyg'),
                            array('key' => 'field_ti_show_button_b2', 'label' => 'Show Button', 'name' => 'show_button', 'type' => 'true_false', 'ui' => 1),
                        ),
                    ),
                     // Layout for FAQ
                    'layout_faq' => array(
                        'key' => 'layout_faq_b2',
                        'name' => 'faq_block',
                        'label' => 'FAQ Block',
                        'display' => 'block',
                        'sub_fields' => array(
                            array('key' => 'field_faq_heading_b2', 'label' => 'Heading', 'name' => 'heading', 'type' => 'text'),
                            array(
                                'key' => 'field_faq_items_b2',
                                'label' => 'FAQ Items',
                                'name' => 'items',
                                'type' => 'repeater',
                                'sub_fields' => array(
                                    array('key' => 'field_faq_question_b2', 'label' => 'Question', 'name' => 'question', 'type' => 'text'),
                                    array('key' => 'field_faq_answer_b2', 'label' => 'Answer', 'name' => 'answer', 'type' => 'wysiwyg'),
                                ),
                            ),
                        ),
                    ),
                    'layout_list_type_1' => array(
                        'key' => 'layout_list_type_1_b2',
                        'name' => 'list_type_1_block',
                        'label' => 'List Type 1 Block',
                        'display' => 'block',
                        'sub_fields' => array(
                            array('key' => 'field_lt1_heading_b2', 'label' => 'Heading', 'name' => 'heading', 'type' => 'text'),
                            array(
                                'key' => 'field_lt1_left_column_b2',
                                'label' => 'Left Column Items',
                                'name' => 'left_column_items',
                                'type' => 'repeater',
                                'sub_fields' => array(
                                    array('key' => 'field_lt1_left_title_b2', 'label' => 'Title', 'name' => 'title', 'type' => 'text'),
                                    array('key' => 'field_lt1_left_description_b2', 'label' => 'Description', 'name' => 'description', 'type' => 'text'),
                                    array('key' => 'field_lt1_left_is_type_2_b2', 'label' => 'Is Type 2?', 'name' => 'is_type_2', 'type' => 'true_false', 'ui' => 1),
                                ),
                            ),
                            array(
                                'key' => 'field_lt1_right_column_b2',
                                'label' => 'Right Column Items',
                                'name' => 'right_column_items',
                                'type' => 'repeater',
                                'sub_fields' => array(
                                    array('key' => 'field_lt1_right_title_b2', 'label' => 'Title', 'name' => 'title', 'type' => 'text'),
                                    array('key' => 'field_lt1_right_description_b2', 'label' => 'Description', 'name' => 'description', 'type' => 'text'),
                                    array('key' => 'field_lt1_right_is_type_2_b2', 'label' => 'Is Type 2?', 'name' => 'is_type_2', 'type' => 'true_false', 'ui' => 1),
                                ),
                            )
                        ),
                    ),
                ),
            ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'page_type',
                    'operator' => '==',
                    'value' => 'front_page',
                ),
            ),
        ),
        'position' => 'normal',
        'style' => 'default',
        'label_placement' => 'top',
    ));
}
add_action('acf/init', 'register_main_page_fields_b2');
