<?php
/**
 * Base Theme 2 functions and definitions
 *
 * @package Base_Theme_2
 */

if (!defined('_S_VERSION')) {
    // Replace the version number of the theme on each release.
    define('_S_VERSION', '1.0.0');
}

/**
 * Sets up theme defaults and registers support for various WordPress features.
 */
function base_theme_2_setup() {
    load_theme_textdomain('base-theme-2', get_template_directory() . '/languages');
    add_theme_support('automatic-feed-links');
    add_theme_support('title-tag');
    add_theme_support('post-thumbnails');

    register_nav_menus(
        array(
            'menu-1' => esc_html__('Primary', 'base-theme-2'),
        )
    );

    add_theme_support(
        'html5',
        array(
            'search-form',
            'comment-form',
            'comment-list',
            'gallery',
            'caption',
            'style',
            'script',
        )
    );

    add_theme_support('customize-selective-refresh-widgets');
}
add_action('after_setup_theme', 'base_theme_2_setup');

function custom_strings_b2() {
    if (function_exists('pll_register_string')) {
        pll_register_string('Get Bonus', 'Get Bonus', 'Base Theme 2');
        pll_register_string('In this review', 'In this review', 'Base Theme 2');
        pll_register_string('Overall Rating:', 'Overall Rating:', 'Base Theme 2');
        pll_register_string('Log In', 'Log In', 'Base Theme 2');
        pll_register_string('Register', 'Register', 'Base Theme 2');
    }
}
add_action('after_setup_theme', 'custom_strings_b2');

/**
 * Enqueue scripts and styles.
 */
function base_theme_2_scripts() {
    wp_enqueue_style('base-theme-2-style', get_stylesheet_uri(), array(), _S_VERSION);
    wp_enqueue_style('base-theme-2-main-style', get_template_directory_uri() . '/assets/public/css/style.min.css', array(), _S_VERSION);
    wp_enqueue_style('base-theme-2-custom-style', get_template_directory_uri() . '/assets/public/css/custom.css', array('base-theme-2-main-style'), _S_VERSION);
}
add_action('wp_enqueue_scripts', 'base_theme_2_scripts');

// Require other theme files
require get_template_directory() . '/fields/main-page-fields.php';
require get_template_directory() . '/fields/ex-page-fields.php';
require get_template_directory() . '/fields/theme-settings-fields.php';
require get_template_directory() . '/inc/template-helpers.php';

if ( function_exists( 'acf_add_options_page' ) ) {

    // Add main options page.
    $parent = acf_add_options_page( [
        'page_title' => 'Theme settings',
        'menu_title' => 'Theme settings',
        'menu_slug'  => 'theme-settings-b2',
        'capability' => 'edit_posts',
        'redirect'   => true,
    ] );

    // Add sub-pages for each language if Polylang is active.
    if ( function_exists( 'pll_languages_list' ) ) {
        $languages = pll_languages_list();
        if ( ! empty( $languages ) ) {
            foreach ( $languages as $lang_slug ) {
                acf_add_options_sub_page( [
                    'page_title'  => 'Settings ' . strtoupper( $lang_slug ),
                    'menu_title'  => 'Settings ' . strtoupper( $lang_slug ),
                    'parent_slug' => $parent['menu_slug'],
                    'menu_slug'   => 'theme-settings-' . $lang_slug, // Keep this slug consistent for field location
                    'post_id'     => 'options_' . $lang_slug // Unique post_id for each language
                ] );
            }
        }
    } else {
        // Fallback if Polylang is not active.
        acf_add_options_sub_page( [
            'page_title'  => 'General Settings',
            'menu_title'  => 'General',
            'parent_slug' => $parent['menu_slug'],
        ] );
    }
}
