<?php
/**
 * Регистрация ACF полей для шаблона Ex-Page
 */
function register_ex_page_fields() {
    if (!function_exists('acf_add_local_field_group')) {
        return;
    }

    // Группа полей для шаблона Ex-Page
    acf_add_local_field_group(array(
        'key' => 'group_ex_page',
        'title' => 'Ex-Page шаблон',
        'fields' => array(
            // ===== ГЛАВНЫЙ БАННЕР =====
            array(
                'key' => 'field_ex_banner_tab',
                'label' => 'Главный баннер',
                'name' => '',
                'type' => 'tab',
                'placement' => 'top',
                'endpoint' => 0,
            ),
            array(
                'key' => 'field_ex_rating',
                'label' => 'Рейтинг',
                'name' => 'ex_rating',
                'type' => 'text',
                'default_value' => 'Overall Rating: 95 / 100',
            ),
            array(
                'key' => 'field_ex_heading',
                'label' => 'Заголовок',
                'name' => 'ex_heading',
                'type' => 'text',
                'required' => 1,
                'default_value' => 'Online Casino Website',
            ),
            array(
                'key' => 'field_ex_subheading',
                'label' => 'Подзаголовок',
                'name' => 'ex_subheading',
                'type' => 'textarea',
                'default_value' => 'The first thing that catches players\'s attention is the incredible simplicity of this casino.',
                'rows' => 3,
                'new_lines' => 'br',
            ),
            array(
                'key' => 'field_ex_image',
                'label' => 'Изображение',
                'name' => 'ex_image',
                'type' => 'image',
                'return_format' => 'array',
                'preview_size' => 'medium',
                'library' => 'all',
            ),
            
            // ===== LOREM БЛОКИ =====
            array(
                'key' => 'field_ex_lorem_tab',
                'label' => 'Lorem секции',
                'name' => '',
                'type' => 'tab',
                'placement' => 'top',
                'endpoint' => 0,
            ),
            array(
                'key' => 'field_ex_lorem_blocks',
                'label' => 'Lorem блоки',
                'name' => 'ex_lorem_blocks',
                'type' => 'repeater',
                'layout' => 'block',
                'button_label' => 'Добавить блок',
                'min' => 0,
                'sub_fields' => array(
                    array(
                        'key' => 'field_ex_lorem_title',
                        'label' => 'Заголовок',
                        'name' => 'title',
                        'type' => 'text',
                    ),
                    array(
                        'key' => 'field_ex_lorem_image',
                        'label' => 'Изображение',
                        'name' => 'image',
                        'type' => 'image',
                        'return_format' => 'array',
                        'preview_size' => 'medium',
                    ),
                    array(
                        'key' => 'field_ex_lorem_content',
                        'label' => 'Содержимое',
                        'name' => 'content',
                        'type' => 'wysiwyg',
                        'tabs' => 'all',
                        'toolbar' => 'full',
                        'media_upload' => 1,
                    ),
                    array(
                        'key' => 'field_ex_lorem_show_button',
                        'label' => 'Показывать кнопку',
                        'name' => 'show_button',
                        'type' => 'true_false',
                        'ui' => 1,
                        'default_value' => 0,
                    ),
                ),
            ),
            
            // ===== FAQ =====
            array(
                'key' => 'field_ex_faq_tab',
                'label' => 'Часто задаваемые вопросы',
                'name' => '',
                'type' => 'tab',
                'placement' => 'top',
                'endpoint' => 0,
            ),
            array(
                'key' => 'field_ex_faq_heading',
                'label' => 'Заголовок',
                'name' => 'ex_faq_heading',
                'type' => 'text',
                'default_value' => 'Frequently Asked Questions',
            ),
            array(
                'key' => 'field_ex_faq_items',
                'label' => 'Вопросы',
                'name' => 'ex_faq_items',
                'type' => 'repeater',
                'layout' => 'block',
                'button_label' => 'Добавить вопрос',
                'pagination' => 0,
                'min' => '',
                'max' => '',
                'rows_per_page' => 20,
                'sub_fields' => array(
                    array(
                        'key' => 'field_ex_faq_question',
                        'label' => 'Вопрос',
                        'name' => 'question',
                        'type' => 'text',
                        'required' => 1,
                    ),
                    array(
                        'key' => 'field_ex_faq_answer',
                        'label' => 'Ответ',
                        'name' => 'answer',
                        'type' => 'wysiwyg',
                        'required' => 1,
                        'tabs' => 'all',
                        'toolbar' => 'full',
                        'media_upload' => 1,
                    ),
                ),
            ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'page_template',
                    'operator' => '==',
                    'value' => 'ex-page-template.php',
                ),
            ),
        ),
        'position' => 'normal',
        'style' => 'default',
        'label_placement' => 'top',
        'instruction_placement' => 'label',
    ));
}

// Регистрация полей при инициализации ACF
add_action('acf/init', 'register_ex_page_fields');
