<?php
/**
 * Регистрация ACF полей для главной страницы (расширенная версия)
 */
function register_main_page_fields() {
    if (!function_exists('acf_add_local_field_group')) {
        return;
    }

    // Группа полей для главной страницы
    acf_add_local_field_group(array(
        'key' => 'group_main_page',
        'title' => 'Главная страница',
        'fields' => array(
            // ===== ГЛАВНЫЙ БАННЕР =====
            array(
                'key' => 'field_main_banner_tab',
                'label' => 'Главный баннер',
                'name' => '',
                'type' => 'tab',
                'placement' => 'top',
                'endpoint' => 0,
            ),
            array(
                'key' => 'field_main_rating',
                'label' => 'Рейтинг',
                'name' => 'main_rating',
                'type' => 'text',
                'required' => 1,
                'default_value' => 'Overall Rating: 95 / 100',
            ),
            array(
                'key' => 'field_main_heading',
                'label' => 'Заголовок',
                'name' => 'main_heading',
                'type' => 'text',
                'required' => 1,
                'default_value' => 'Online Casino Website',
            ),
            array(
                'key' => 'field_main_subheading',
                'label' => 'Подзаголовок',
                'name' => 'main_subheading',
                'type' => 'textarea',
                'default_value' => 'The first thing that catches players\' attention is the incredible simplicity of this casino.',
                'rows' => 3,
                'new_lines' => 'br',
            ),
            array(
                'key' => 'field_main_image',
                'label' => 'Изображение',
                'name' => 'main_image',
                'type' => 'image',
                'required' => 1,
                'return_format' => 'array',
                'preview_size' => 'medium',
                'library' => 'all',
            ),
            
            // ===== ВВОДНЫЙ ТЕКСТ =====
            array(
                'key' => 'field_intro_text_tab',
                'label' => 'Вводный текст',
                'name' => '',
                'type' => 'tab',
                'placement' => 'top',
                'endpoint' => 0,
            ),
            array(
                'key' => 'field_intro_content',
                'label' => 'Вводный текст',
                'name' => 'intro_content',
                'type' => 'wysiwyg',
                'tabs' => 'all',
                'toolbar' => 'full',
                'media_upload' => 1,
                'default_value' => '<p>Formidabile sito di scommesse online, con 22Bet potrete realizzare i vostri desideri, trasformando il vostro hobby preferito in una fonte di guadagno. Questo allibratore è esperto di servizi di casinò e sportsbook, consentendo a chiunque lo utilizzi di scegliere l\'esperienza di gioco che più li gratifichi.</p><p>Formidabile sito di scommesse online, con 22Bet potrete realizzare i vostri desideri, trasformando il vostro hobby preferito in una fonte di guadagno. Questo allibratore è esperto di servizi di casinò e sportsbook, consentendo a chiunque lo utilizzi di scegliere l\'esperienza di gioco che più li gratifichi.</p>',
            ),
            
            // ===== ТОП ИГРЫ =====
            array(
                'key' => 'field_games_tab',
                'label' => 'Топ игры',
                'name' => '',
                'type' => 'tab',
                'placement' => 'top',
                'endpoint' => 0,
            ),
            array(
                'key' => 'field_games_heading',
                'label' => 'Заголовок',
                'name' => 'games_heading',
                'type' => 'text',
                'required' => 1,
                'default_value' => 'Top Games',
            ),
            array(
                'key' => 'field_games_count',
                'label' => 'Количество игр',
                'name' => 'games_count',
                'type' => 'text',
                'default_value' => '48 games',
            ),
            array(
                'key' => 'field_games_list',
                'label' => 'Игры',
                'name' => 'games_list',
                'type' => 'repeater',
                'layout' => 'table',
                'button_label' => 'Добавить игру',
                'pagination' => 0,
                'min' => '',
                'max' => '',
                'rows_per_page' => 20,
                'sub_fields' => array(
                    array(
                        'key' => 'field_game_image',
                        'label' => 'Изображение',
                        'name' => 'game_image',
                        'type' => 'image',
                        'required' => 1,
                        'return_format' => 'array',
                        'preview_size' => 'medium',
                        'library' => 'all',
                    ),
                    array(
                        'key' => 'field_game_name',
                        'label' => 'Название игры',
                        'name' => 'game_name',
                        'type' => 'text',
                        'required' => 1,
                    ),
                    array(
                        'key' => 'field_game_brand',
                        'label' => 'Производитель',
                        'name' => 'game_brand',
                        'type' => 'text',
                    ),
                    array(
                        'key' => 'field_game_color',
                        'label' => 'Цвет',
                        'name' => 'game_color',
                        'type' => 'select',
                        'choices' => array(
                            'orange-item' => 'Оранжевый',
                            'red-item' => 'Красный',
                            'purple-item' => 'Фиолетовый',
                        ),
                        'default_value' => array(
                            0 => 'orange-item',
                        ),
                        'return_format' => 'value',
                    ),
                ),
            ),
            
            // ===== КЛЮЧЕВЫЕ ФАКТЫ =====
            array(
                'key' => 'field_key_facts_tab',
                'label' => 'Ключевые факты',
                'name' => '',
                'type' => 'tab',
                'placement' => 'top',
                'endpoint' => 0,
            ),
            array(
                'key' => 'field_key_facts_heading',
                'label' => 'Заголовок секции фактов',
                'name' => 'key_facts_heading',
                'type' => 'text',
                'default_value' => 'Key facts',
            ),
            array(
                'key' => 'field_key_facts_items',
                'label' => 'Список фактов',
                'name' => 'key_facts_items',
                'type' => 'repeater',
                'layout' => 'table',
                'button_label' => 'Добавить факт',
                'pagination' => 0,
                'min' => '',
                'max' => '',
                'sub_fields' => array(
                    array(
                        'key' => 'field_fact_label',
                        'label' => 'Название факта',
                        'name' => 'fact_label',
                        'type' => 'text',
                        'required' => 1,
                    ),
                    array(
                        'key' => 'field_fact_value',
                        'label' => 'Значение',
                        'name' => 'fact_value',
                        'type' => 'text',
                        'required' => 1,
                    ),
                ),
            ),
            array(
                'key' => 'field_advantages_heading',
                'label' => 'Заголовок секции преимуществ',
                'name' => 'advantages_heading',
                'type' => 'text',
                'default_value' => 'Advantages',
            ),
            array(
                'key' => 'field_advantages_items',
                'label' => 'Список преимуществ',
                'name' => 'advantages_items',
                'type' => 'repeater',
                'layout' => 'table',
                'button_label' => 'Добавить преимущество',
                'pagination' => 0,
                'min' => '',
                'max' => '',
                'sub_fields' => array(
                    array(
                        'key' => 'field_advantage_text',
                        'label' => 'Текст преимущества',
                        'name' => 'advantage_text',
                        'type' => 'text',
                        'required' => 1,
                    ),
                ),
            ),
            
            // ===== БОНУСЫ =====
            array(
                'key' => 'field_bonus_hub_tab',
                'label' => 'Бонусы',
                'name' => '',
                'type' => 'tab',
                'placement' => 'top',
                'endpoint' => 0,
            ),
            array(
                'key' => 'field_bonus_hub_heading',
                'label' => 'Заголовок секции бонусов',
                'name' => 'bonus_hub_heading',
                'type' => 'text',
                'default_value' => 'Bonus Hub',
            ),
            array(
                'key' => 'field_bonus_items',
                'label' => 'Список бонусов',
                'name' => 'bonus_items',
                'type' => 'repeater',
                'layout' => 'block',
                'button_label' => 'Добавить бонус',
                'pagination' => 0,
                'min' => '',
                'max' => '',
                'sub_fields' => array(
                    array(
                        'key' => 'field_bonus_name',
                        'label' => 'Название бонуса',
                        'name' => 'bonus_name',
                        'type' => 'text',
                        'required' => 1,
                    ),
                    array(
                        'key' => 'field_bonus_cash',
                        'label' => 'Сумма бонуса',
                        'name' => 'bonus_cash',
                        'type' => 'text',
                        'required' => 1,
                    ),
                    array(
                        'key' => 'field_bonus_spins',
                        'label' => 'Фриспины',
                        'name' => 'bonus_spins',
                        'type' => 'text',
                    ),
                    array(
                        'key' => 'field_bonus_button',
                        'label' => 'Текст кнопки',
                        'name' => 'bonus_button',
                        'type' => 'text',
                        'default_value' => 'Sign up',
                    ),
                    array(
                        'key' => 'field_bonus_link',
                        'label' => 'Ссылка кнопки',
                        'name' => 'bonus_link',
                        'type' => 'text',
                        'default_value' => '/',
                    ),
                    array(
                        'key' => 'field_bonus_image',
                        'label' => 'Изображение',
                        'name' => 'bonus_image',
                        'type' => 'image',
                        'return_format' => 'array',
                        'preview_size' => 'medium',
                        'library' => 'all',
                    ),
                ),
            ),

            // ===== LOREM =====
            array(
                'key' => 'field_lorem_tab',
                'label' => 'Lorem секция',
                'name' => '',
                'type' => 'tab',
                'placement' => 'top',
                'endpoint' => 0,
            ),
            array(
                'key' => 'field_lorem_blocks',
                'label' => 'Блоки контента',
                'name' => 'lorem_blocks',
                'type' => 'repeater',
                'layout' => 'block',
                'button_label' => 'Добавить блок',
                'pagination' => 0,
                'min' => '',
                'max' => '',
                'sub_fields' => array(
                    array(
                        'key' => 'field_lorem_block_title',
                        'label' => 'Заголовок',
                        'name' => 'title',
                        'type' => 'text',
                        'required' => 1,
                        'default_value' => 'Lorem ipsum dolor sit amet',
                    ),
                    array(
                        'key' => 'field_lorem_block_image',
                        'label' => 'Изображение',
                        'name' => 'image',
                        'type' => 'image',
                        'return_format' => 'array',
                        'preview_size' => 'medium',
                        'library' => 'all',
                        'default_value' => '',
                    ),
                    array(
                        'key' => 'field_lorem_block_content',
                        'label' => 'Содержимое',
                        'name' => 'content',
                        'type' => 'wysiwyg',
                        'tabs' => 'all',
                        'toolbar' => 'full',
                        'media_upload' => 1,
                        'default_value' => '<p>Formidabile sito di scommesse online, con 22Bet potrete realizzare i vostri desideri, trasformando il vostro hobby preferito in una fonte di guadagno. Questo allibratore è esperto di servizi di casinò e sportsbook, consentendo a chiunque lo utilizzi di scegliere l\'esperienza di gioco che più li gratifichi.</p><p>Si possono effettuare scommesse in pochi clic e bastano appena 24 ore per ricevere il denaro vinto.</p>',
                    ),
                    array(
                        'key' => 'field_lorem_block_show_button',
                        'label' => 'Показывать кнопку',
                        'name' => 'show_button',
                        'type' => 'true_false',
                        'ui' => 1,
                        'default_value' => 0,
                    ),
                ),
            ),
            
            // ===== РЕЙТИНГИ =====
            array(
                'key' => 'field_ratings_tab',
                'label' => 'Рейтинги',
                'name' => '',
                'type' => 'tab',
                'placement' => 'top',
                'endpoint' => 0,
            ),
            array(
                'key' => 'field_ratings_heading',
                'label' => 'Заголовок секции рейтингов',
                'name' => 'ratings_heading',
                'type' => 'text',
                'default_value' => 'Ratings of 22Bet Services',
            ),
            array(
                'key' => 'field_ratings_items',
                'label' => 'Список рейтингов',
                'name' => 'ratings_items',
                'type' => 'repeater',
                'layout' => 'table',
                'button_label' => 'Добавить рейтинг',
                'pagination' => 0,
                'min' => '',
                'max' => '',
                'sub_fields' => array(
                    array(
                        'key' => 'field_rating_service',
                        'label' => 'Название сервиса',
                        'name' => 'rating_service',
                        'type' => 'text',
                        'required' => 1,
                    ),
                    array(
                        'key' => 'field_rating_score',
                        'label' => 'Оценка',
                        'name' => 'rating_score',
                        'type' => 'text',
                        'required' => 1,
                    ),
                ),
            ),
            array(
                'key' => 'field_ratings_button',
                'label' => 'Кнопка',
                'name' => 'ratings_button',
                'type' => 'link',
                'return_format' => 'array',
            ),
            
            // ===== FAQ =====
            array(
                'key' => 'field_faq_tab',
                'label' => 'Часто задаваемые вопросы',
                'name' => '',
                'type' => 'tab',
                'placement' => 'top',
                'endpoint' => 0,
            ),
            array(
                'key' => 'field_faq_heading',
                'label' => 'Заголовок',
                'name' => 'faq_heading',
                'type' => 'text',
                'default_value' => 'Frequently Asked Questions',
            ),
            array(
                'key' => 'field_faq_items',
                'label' => 'Вопросы',
                'name' => 'faq_items',
                'type' => 'repeater',
                'layout' => 'block',
                'button_label' => 'Добавить вопрос',
                'pagination' => 0,
                'min' => '',
                'max' => '',
                'rows_per_page' => 20,
                'sub_fields' => array(
                    array(
                        'key' => 'field_faq_question',
                        'label' => 'Вопрос',
                        'name' => 'question',
                        'type' => 'text',
                        'required' => 1,
                    ),
                    array(
                        'key' => 'field_faq_answer',
                        'label' => 'Ответ',
                        'name' => 'answer',
                        'type' => 'wysiwyg',
                        'required' => 1,
                        'tabs' => 'all',
                        'toolbar' => 'full',
                        'media_upload' => 1,
                    ),
                ),
            ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'page_type',
                    'operator' => '==',
                    'value' => 'front_page',
                ),
            ),
        ),
        'position' => 'normal',
        'style' => 'default',
        'label_placement' => 'top',
        'instruction_placement' => 'label',
    ));
}

// Регистрация полей при инициализации ACF
add_action('acf/init', 'register_main_page_fields');