<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Casino_Theme
 */

?>
<?php 
$link_url = casino_get_global_button_url();
?>

<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">

    <?php wp_head(); ?>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link href="https://fonts.googleapis.com/css2?family=Saira:ital,wght@0,100..900;1,100..900&amp;display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/public/css/style.min.css">
</head>

<body>
    <div class="body-wrap" id="backTop">
      <header class="header">
        <div class="header__container">
          <div class="header__logo_container">
            <?php
            // Получаем логотип из настроек темы
            $header_logo_data = casino_get_header_logo();
            $logo_url = $header_logo_data['url'];
            $logo_alt = $header_logo_data['alt'];
            ?>
            <a class="header__logo" href="<?php echo esc_url(home_url('/')); ?>"><img src="<?php echo esc_url($logo_url); ?>" alt="<?php echo esc_attr($logo_alt); ?>"></a>
            <div class="header__menu">
              <ul>
                <?php
                // Получаем меню из настроек темы
                $menu_items = casino_get_menu_items();
                if ($menu_items) :
                  foreach ($menu_items as $item) :
                    $title = isset($item['title']) ? $item['title'] : '';
                    $url = isset($item['url']) ? $item['url'] : '#';
                    $target = isset($item['target']) && $item['target'] ? '_blank' : '_self';
                    $has_submenu = isset($item['submenu']) && is_array($item['submenu']) && !empty($item['submenu']);
                ?>
                <li>
                  <a class="header__menu_item" href="<?php echo esc_url($url); ?>" target="<?php echo esc_attr($target); ?>">
                    <span><?php echo esc_html($title); ?></span>
                    <?php if ($has_submenu) : ?>
                      <img class="arrow" src="<?php echo get_template_directory_uri(); ?>/assets/public/img/icons/arrow-down-grey.svg" alt="">
                    <?php endif; ?>
                  </a>
                  <?php if ($has_submenu) : ?>
                  <ul>
                    <?php foreach ($item['submenu'] as $subitem) :
                      $subtitle = isset($subitem['title']) ? $subitem['title'] : '';
                      $suburl = isset($subitem['url']) ? $subitem['url'] : '#';
                      $subtarget = isset($subitem['target']) && $subitem['target'] ? '_blank' : '_self';
                    ?>
                    <li>
                      <a href="<?php echo esc_url($suburl); ?>" target="<?php echo esc_attr($subtarget); ?>"><?php echo esc_html($subtitle); ?></a>
                    </li>
                    <?php endforeach; ?>
                  </ul>
                  <?php endif; ?>
                </li>
                <?php
                  endforeach;
                else :
                  // Дефолтное меню, если нет настроек
                ?>
                <?php endif; ?>
              </ul>
            </div>
          </div>
          <div class="header__buttons_container">
            <div class="header__lang">
              <?php if (function_exists('pll_the_languages')): 
                $current_lang = pll_current_language();
                $languages = pll_the_languages(array('raw' => 1));
                
                // Get current language data
                $current_lang_data = isset($languages[$current_lang]) ? $languages[$current_lang] : false;
                $current_lang_code = $current_lang;
                $current_lang_name = $current_lang_data ? $current_lang_data['name'] : 'EN';
                
                // Language flag mapping
                $lang_flags = [
                  'en' => 'uk',
                  'de' => 'de',
                  'es' => 'es',
                  'fr' => 'fr',
                  'it' => 'it',
                  'pt' => 'pt',
                ];
              ?>
              <div class="header__lang_item header__lang_item--active data-toggle">
                <img src="<?php echo get_template_directory_uri(); ?>/assets/public/img/icons/flags/<?php echo isset($lang_flags[strtolower($current_lang_code)]) ? $lang_flags[strtolower($current_lang_code)] : 'uk'; ?>.svg" alt="<?php echo esc_attr($current_lang_name); ?>">
                <img class="arrow" src="<?php echo get_template_directory_uri(); ?>/assets/public/img/icons/arrow-down-white.svg" alt="">
              </div>
              <div class="header__lang_hidden">
                <?php foreach ($languages as $lang_code => $lang): 
                  if ($lang_code !== $current_lang): 
                    $flag_code = isset($lang_flags[strtolower($lang_code)]) ? $lang_flags[strtolower($lang_code)] : 'uk';
                ?>
                <a class="header__lang_item data-toggle-item" href="<?php echo esc_url($lang['url']); ?>">
                  <img src="<?php echo get_template_directory_uri(); ?>/assets/public/img/icons/flags/<?php echo $flag_code; ?>.svg" alt="<?php echo esc_attr($lang['name']); ?>">
                </a>
                <?php endif; endforeach; ?>
              </div>
              <?php endif; ?>
            </div>

            <a href="<?php echo esc_url($link_url); ?>" class="button button--login">
              <span><?php pll_e('log_in'); ?></span>
            </a>
            <a href="<?php echo esc_url($link_url); ?>" class="button button--register button--colored">
              <span><?php pll_e('sign_up'); ?></span>
            </a>
          </div>
          <div class="header__mob_menu"> 
            <div id="burger" onclick="enable()"><span> </span><span class="ultinate"></span><span> </span></div>
            <nav class="nav" id="nav"><a class="nav__mob_logo" href="<?php echo esc_url(home_url('/')); ?>"><img src="<?php echo esc_url($logo_url); ?>" alt="<?php echo esc_attr($logo_alt); ?>"></a>
              <div class="nav__menu"> 
                <ul>
                  <?php
                  // Используем то же меню для мобильной версии
                  if ($menu_items) :
                    foreach ($menu_items as $item) :
                      $title = isset($item['title']) ? $item['title'] : '';
                      $url = isset($item['url']) ? $item['url'] : '#';
                      $target = isset($item['target']) && $item['target'] ? '_blank' : '_self';
                      $has_submenu = isset($item['submenu']) && is_array($item['submenu']) && !empty($item['submenu']);
                      
                      if ($has_submenu) :
                  ?>
                  <li class="show-item"><span><?php echo esc_html($title); ?></span>
                    <ul class="show-text">
                      <?php foreach ($item['submenu'] as $subitem) :
                        $subtitle = isset($subitem['title']) ? $subitem['title'] : '';
                        $suburl = isset($subitem['url']) ? $subitem['url'] : '#';
                        $subtarget = isset($subitem['target']) && $subitem['target'] ? '_blank' : '_self';
                      ?>
                      <li><a href="<?php echo esc_url($suburl); ?>" target="<?php echo esc_attr($subtarget); ?>"><span><?php echo esc_html($subtitle); ?></span></a></li>
                      <?php endforeach; ?>
                    </ul>
                  </li>
                  <?php else : ?>
                  <li><a href="<?php echo esc_url($url); ?>" target="<?php echo esc_attr($target); ?>"><span><?php echo esc_html($title); ?></span></a></li>
                  <?php 
                      endif;
                    endforeach;
                  else :
                  // Дефолтное мобильное меню
                  ?>
                  <?php endif; ?>
                </ul>
              </div>
              <div class="nav__lang">
                <?php if (function_exists('pll_the_languages')): 
                  $current_lang = pll_current_language();
                  $languages = pll_the_languages(array('raw' => 1));
                  
                  // Language flag mapping
                  $lang_flags = [
                    'en' => 'uk',
                    'de' => 'de',
                    'es' => 'es',
                    'fr' => 'fr',
                    'it' => 'it',
                    'pt' => 'pt',
                  ];
                ?>
                <div class="nav__lang_title"><?php pll_e('language'); ?></div>
                <div class="nav__lang_items">
                  <?php foreach ($languages as $lang_code => $lang): 
                    $flag_code = isset($lang_flags[strtolower($lang_code)]) ? $lang_flags[strtolower($lang_code)] : 'uk';
                    $is_current = $lang_code === $current_lang;
                  ?>
                  <a class="nav__lang_item <?php echo $is_current ? 'nav__lang_item--active' : ''; ?>" href="<?php echo esc_url($lang['url']); ?>">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/public/img/icons/flags/<?php echo $flag_code; ?>.svg" alt="<?php echo esc_attr($lang['name']); ?>">
                    <span><?php echo esc_html($lang['name']); ?></span>
                  </a>
                  <?php endforeach; ?>
                </div>
                <?php endif; ?>
              </div>
              
              <div class="nav__btns"> 
                <a class="button button--login" href="<?php echo esc_url($link_url); ?>"><span><?php pll_e('log_in'); ?></span></a>
                <a class="button button--register button--colored" href="<?php echo esc_url($link_url); ?>"><span><?php pll_e('sign_up'); ?></span></a>
              </div>
            </nav>
          </div>
        </div>
      </header>